<?php 
$pageTitle="profile";

include "templates/header.php";


?>
    <!-- Main Content -->
    <div class="profile container-fluid ">
        <div>
            <h2 class="  ">
                Mon Profile
            </h2>
        </div>
        <?php
        if (isset($_SESSION['success_message'])) {
            echo '<div class="alert alert-success text-center">' . htmlspecialchars($_SESSION['success_message']) . '</div>';
            unset($_SESSION['success_message']);
        }elseif (isset($_SESSION['error_message'])) {
            echo '<div class="alert alert-danger text-center">' . htmlspecialchars($_SESSION['error_message']) . '</div>';
            unset($_SESSION['error_message']);
        }?>        
        <div class="row mt-3">
            <div class="col-sm-3 mb-3 mb-sm-0">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-center align-items-center flex-column mb-3">
                            <img src="https://ui-avatars.com/api/?name=<?php echo htmlspecialchars($_SESSION['username']); ?>&color=fff&background=0D8ABC" alt="" class="img-fluid rounded-circle" style="width: 100px; height: 100px;">
                        </div>
                        <div id="info">
                            <p><i class="ri-user-fill text-primary"></i> <strong><?php echo htmlspecialchars($user->getUsername()); ?></strong></p>
                            <p><i class="ri-mail-fill text-primary"></i> <strong><?php echo htmlspecialchars($user->getEmail()); ?></strong></p>
                            <hr>
                            <p><i class="ri-calendar-fill text-primary"></i> <strong>inscrit le:</strong> <?php echo htmlspecialchars($user->getCreatedAt()); ?></p>
                        </div>
                        <a href="index.php?action=edit_profile" class="btn btn-outline-warning" 
                            id="user"
                            
                            data-nom="<?php echo htmlspecialchars($user->getUsername()); ?>"
                            data-email="<?php echo htmlspecialchars($user->getEmail()); ?>"
                        >
                            <i class="ri-pencil-line"></i> 
                            modifier
                        </a>
                        <button type="button" class="btn btn-outline-danger" 
                            data-bs-toggle="modal" 
                            data-bs-target="#deleteAccountModal">
                            <i class="ri-delete-bin-line"></i> 
                            Supprimer mon compte
                        </button>
                    </div>
                </div>
            </div>
            <div class="col-sm-9">
                <div class="card">
                    <div class="card-body">
                        <ul class="nav nav-pills d-flex" id="myTab" role="tablist">
                            <li class="nav-item flex-fill text-center" role="presentation">
                                <button class="nav-link active w-100" id="home-tab" data-bs-toggle="tab" data-bs-target="#home" type="button" role="tab" aria-controls="home" aria-selected="false">Projets</button>
                            </li>
                            <li class="nav-item flex-fill text-center" role="presentation">
                                <button class="nav-link w-100" id="profile-tab" data-bs-toggle="tab" data-bs-target="#profile" type="button" role="tab" aria-controls="profile" aria-selected="true">Contributions</button>
                            </li>
                        </ul>
                        <hr>
                        <div class="tab-content mt-3">
                            <!-- Onglet Projets -->
                            <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
                                <h4 class="form-text position-relative"></h4>
                                <p>
                                    Mes projets (<?php echo count($projects); ?>)
                                </p>
                                <!-- Contenu des projets -->
                                <div class="row">
                                    <?php
                                    $itemsPerPage = 3;
                                    $totalProjects = count($projects);
                                    $totalPages = ceil($totalProjects / $itemsPerPage);
                                    $currentPage = isset($_GET['page']) ? (int)$_GET['page'] : 1;
                                    $currentPage = max(1, min($currentPage, $totalPages));
                                    $startIndex = ($currentPage - 1) * $itemsPerPage;
                                    $paginatedProjects = array_slice($projects, $startIndex, $itemsPerPage);
                                    ?>

                                    <?php if (empty($projects)): ?>
                                        <div class="col text-center">
                                            <p>Aucun projet trouvé.</p>
                                        </div>
                                    <?php else: ?>
                                        <?php foreach ($paginatedProjects as $project): ?>
                                            <div class="col-sm-4 mb-3">
                                                <div class="card h-100">
                                                    <div class="card-header bg-info">                                                        
                                                      <h5 class="card-title"> <?php echo htmlspecialchars($project["titre"]); ?></h5>
                                                    </div>
                                                    <div class="card-body">
                                                        <p class="card-text font-weight-bold"> <strong>Objectif : <span class="text-success"><?php echo htmlspecialchars($project['objectif'])  ?> XAF </span></strong> </p>
                                                        <p class="card-text font-weight-bold"> <strong>Collecte :</strong> <span class=""><?php echo htmlspecialchars($project['current_amount'])  ?> XAF </span> </p>
                                                        <p class="card-text font-weight-bold"> <strong>Fin de collecte: </strong> <span class=""><?php echo htmlspecialchars($project['end_date'])  ?> </span> </p>
                                                        <p class="card-text font-weight-bold"> <strong>Catégorie: </strong><span class=""><?php echo htmlspecialchars($project['categorie'])  ?> </span> </p>
                                                        <p class="card-text font-weight-bold"> <strong>Catégorie: </strong><span class=""><?php echo htmlspecialchars($project['created_at'])  ?> </span> </p>
                                                        <div class="progress" role="progressbar" aria-label="Animated striped example" aria-valuenow="<?php echo htmlspecialchars($project['current_amount']) ?>" aria-valuemin="0" aria-valuemax="<?php echo htmlspecialchars($project['objectif']) ?>">
                                                            <div class="progress-bar progress-bar-striped progress-bar-animated bg-success" style="width: <?php echo (htmlspecialchars($project['current_amount']) / htmlspecialchars($project['objectif'])) * 100; ?>%">
                                                               <span class="text-warning"><?php echo round((htmlspecialchars($project['current_amount']) / htmlspecialchars($project['objectif'])) * 100); ?>%</span>
                                                            </div>
                                                        </div>
                                                        <div class="d-flex justify-content-between mt-3">
                                                            <div>
                                                                <button type="button" class="btn btn-danger delete-btn" 
                                                                    data-bs-toggle="modal" 
                                                                    data-bs-target="#deleteProjectModal"
                                                                    data-id="<?php echo htmlspecialchars($project['id']); ?>" 
                                                                    data-titre="<?php echo htmlspecialchars($project["titre"]); ?>">
                                                                    <i class="ri-delete-bin-line"></i> 
                                                                </button>
                                                            </div>
                                                            <div>
                                                                <a href="index.php?action=edit_project&id=<?php echo htmlspecialchars($project['id']); ?>" class="btn btn-warning">
                                                                    <i class="ri-pencil-line"></i> 
                                                                </a>
                                                                <a href="index.php?action=project&id=<?php echo htmlspecialchars($project['id']); ?>" class="btn btn-primary ">Voir le projet</a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </div>

                                <!-- Pagination -->
                                <nav>
                                    <ul class="pagination justify-content-center">
                                        <?php if ($currentPage > 1): ?>
                                            <li class="page-item">
                                                <a class="page-link" href="index.php?action=profile&page=<?php echo $currentPage - 1; ?>" aria-label="Précédent">
                                                    <span aria-hidden="true">&laquo;</span>
                                                </a>
                                            </li>
                                        <?php endif; ?>

                                        <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                                            <li class="page-item <?php echo $i === $currentPage ? 'active' : ''; ?>">
                                                <a class="page-link" href="index.php?action=profile&page=<?php echo $i; ?>"><?php echo $i; ?></a>
                                            </li>
                                        <?php endfor; ?>

                                        <?php if ($currentPage < $totalPages): ?>
                                            <li class="page-item">
                                                <a class="page-link" href="index.php?action=profile&page=<?php echo $currentPage + 1; ?>" aria-label="Suivant">
                                                    <span aria-hidden="true">&raquo;</span>
                                                </a>
                                            </li>
                                        <?php endif; ?>
                                    </ul>
                                </nav>
                            </div>

                            <!-- Onglet Contributions -->
                            <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                                <h4>Mes contributions</h4>
                                <p>
                                    <!-- Exemple de contenu pour les contributions -->
                                    <?php if (empty($contributions)): ?>
                                        <p class="alert alert-danger text-center">Vous n'avez pas encore éffectué de contribution!!</p>
                                    <?php else: ?>
                                        <ul>
                                            <?php foreach ($contributions as $contribution): ?>
                                                <li>
                                                    Projet : <?php echo htmlspecialchars($contribution['project_title']); ?> - Montant : <?php echo htmlspecialchars($contribution['montant']); ?> XAF
                                                </li>
                                            <?php endforeach; ?>
                                        </ul>
                                    <?php endif; ?>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="edituserModal" tabindex="-1" aria-labelledby="edituserModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header bg-warning text-white text-center">
                        <h5 class="modal-title text-center" id="edituserModalLabel">Modifier le profil</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form method="post" action="index.php?action=edit_profile_process">
                            <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($_SESSION['csrf_token']); ?>">
                            <div class="mb-3">
                                <label for="nom" class="col-form-label">Nom:</label>
                                <input type="text" class="form-control" id="nom" name="nom" value="<?php echo htmlspecialchars($user->getUsername()); ?>" required>
                            </div>
                            <div class="mb-3">
                                <label for="email" class="col-form-label">Email:</label>
                                <input type="email" class="form-control" id="email" name="email" value="<?php echo htmlspecialchars($user->getEmail()); ?>" required>
                            </div>
                            <div class="mb-3">
                                <label for="current_password" class="col-form-label">Mot de passe actuel:</label>
                                <input type="password" class="form-control" id="current_password" name="current_password">
                                <small class="form-text text-muted">Laissez vide si vous ne souhaitez pas changer le mot de passe</small>
                            </div>
                            <div class="mb-3">
                                <label for="new_password" class="col-form-label">Nouveau mot de passe:</label>
                                <input type="password" class="form-control" id="new_password" name="new_password">
                            </div>
                            <div class="mb-3">
                                <label for="confirm_password" class="col-form-label">Confirmer le nouveau mot de passe:</label>
                                <input type="password" class="form-control" id="confirm_password" name="confirm_password">
                            </div>
                            <div class="d-flex justify-content-end">
                                <button type="button" class="btn btn-secondary me-2" data-bs-dismiss="modal">Annuler</button>
                                <button type="submit" class="btn btn-primary">Enregistrer</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="deleteProjectModal" tabindex="-1" aria-labelledby="deleteProjectModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header bg-danger text-white">
                        <h5 class="modal-title" id="deleteProjectModalLabel">Confirmation de suppression</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body text-center">
                        <p class="mb-4">Êtes-vous sûr de vouloir supprimer ce projet ? Cette action est irréversible.</p>
                        <i class="ri-error-warning-line text-danger" style="font-size: 3rem;"></i>
                    </div>
                    <div class="modal-footer justify-content-center">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Annuler</button>
                        <form method="post" action="index.php?action=delete_project" style="display: inline;">
                            <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($_SESSION['csrf_token']); ?>">
                            <input type="hidden" name="project_id" id="delete_project_id" value="">
                            <button type="submit" class="btn btn-danger">Supprimer</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Modal de suppression de compte -->
        <div class="modal fade" id="deleteAccountModal" tabindex="-1" aria-labelledby="deleteAccountModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header bg-danger text-white">
                        <h5 class="modal-title" id="deleteAccountModalLabel">Confirmation de suppression de compte</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body text-center">
                        <p class="mb-4">Êtes-vous sûr de vouloir supprimer votre compte ? Cette action est irréversible et supprimera toutes vos données.</p>
                        <i class="ri-error-warning-line text-danger" style="font-size: 3rem;"></i>
                    </div>
                    <div class="modal-footer justify-content-center">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Annuler</button>
                        <form method="post" action="index.php?action=delete_account" style="display: inline;">
                            <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($_SESSION['csrf_token']); ?>">
                            <button type="submit" class="btn btn-danger">Supprimer mon compte</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Bootstrap JS and Popper.js -->
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            // Remplir automatiquement les champs du modal avec les infos utilisateur
            document.getElementById('user').addEventListener('click', function () {
                const nom = this.getAttribute('data-nom');
                const email = this.getAttribute('data-email');
                document.getElementById('nom').value = nom;
                document.querySelector('#edituserModal input[name="email"]').value = email;
            });

            // Utilise l'événement Bootstrap pour remplir dynamiquement le modal de suppression
            var deleteProjectModal = document.getElementById('deleteProjectModal');
            if (deleteProjectModal) {
                deleteProjectModal.addEventListener('show.bs.modal', function (event) {
                    var button = event.relatedTarget;
                    if (!button) return;
                    var id = button.getAttribute('data-id');
                    var titre = button.getAttribute('data-titre');
                    // Met à jour l'ID du projet dans le formulaire de suppression
                    document.getElementById('delete_project_id').value = id;
                    // Met à jour le titre du modal
                    document.getElementById('deleteProjectModalLabel').textContent = "Supprimer le projet : " + titre;
                });
            }

            // Validation du formulaire de modification de profil
            const editForm = document.querySelector('#edituserModal form');
            if (editForm) {
                editForm.addEventListener('submit', function(e) {
                    const newPassword = document.getElementById('new_password').value;
                    const confirmPassword = document.getElementById('confirm_password').value;
                    const currentPassword = document.getElementById('current_password').value;

                    if (newPassword || confirmPassword || currentPassword) {
                        if (!currentPassword) {
                            e.preventDefault();
                            alert('Le mot de passe actuel est requis pour changer le mot de passe');
                            return;
                        }
                        if (newPassword !== confirmPassword) {
                            e.preventDefault();
                            alert('Les nouveaux mots de passe ne correspondent pas');
                            return;
                        }
                        if (newPassword.length < 8) {
                            e.preventDefault();
                            alert('Le nouveau mot de passe doit contenir au moins 8 caractères');
                            return;
                        }
                    }
                });
            }
        });
    </script>
</body>
</html>