<!DOCTYPE html>
<html lang="fr">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($pageTitle) ? $pageTitle . ' - ' : ''; ?>COMMUNIFY</title>
    <link rel="shortcut icon" href="/public/images/logo.png" type="image/x-icon">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-rbsA2VBKQhggwzxH7pPCaAqO46MgnOM80zW1RWuH61DGLwZJEdK2Kadq2F9CUG65" crossorigin="anonymous">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js" defer
        integrity="sha384-kenU1KFdBIe4zVF0s0G1M5b4hcpxyD9F7jL+jjXkk+Q2h455rYXK/7HAuoJl+0I4"
        crossorigin="anonymous"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css"
        integrity="sha512-Evv84Mr4kqVGRNSgIGL/F/aIDqQb7xQ2vcrdIwxfjThSH8CSR7PBEakCr51Ck+w+/U6swU2Im1vVX0SVk9ABhg=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <!-- Remix Icon CDN -->
    <link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/css/intlTelInput.css">
    <link rel="stylesheet" href="/public/css/accueil.css">
    <link rel="stylesheet" href="/public/css/general.css">
    <script src="/public/js/carousel.js" defer></script>
</head>

<body>

    <?php
    $currentPage = $_GET['action'] ?? 'home';
    ?>
    <header class="position-fixed custom-header">
        <input type="checkbox" id="nav-toggle">
        <label for="nav-toggle" class="hamburger-button">&#9776;</label>

        <div class="brand-logo">
            <i class="ri-building-2-fill"></i>
            <span><a href="/" class="text-primary">COMMUNIFY</a></span>
        </div>

        <nav class="navigation-menu">
            <a href="/" class="<?= $currentPage == 'home' ? 'active' : '' ?>">Accueil</a>
            <a href="index.php?action=projects" class="<?= $currentPage == 'projects' ? 'active' : '' ?>">Projets</a>
            <a href="#" style="display: none;" class=" <?= $currentPage == 'about' ? 'active' : '' ?>">À propos</a>

            <?php if (isset($_SESSION['user_id'])): ?>
                <a class="<?= $currentPage == 'create_project' ? 'active' : '' ?>"
                    href="index.php?action=create_project">Créer un projet</a>
                <a class="<?= $currentPage == 'profile' ? 'active' : '' ?>" href="index.php?action=profile"><i
                        class="ri-user-line"></i> Mon compte</a>
                <a href="index.php?action=logout">Déconnexion</a>
            <?php else: ?>
            </nav>

            <div class="mobile-icons">
                <a href="index.php?action=login" title="Se connecter"><i class="ri-login-box-line"></i></a>
                <a href="index.php?action=register" title="Créer un compte"><i class="ri-user-add-line"></i></a>
            </div>
            <div class="desktop-icons">
                <a class="<?= $currentPage == 'login' ? 'active' : '' ?>" href="index.php?action=login"
                    title="Se connecter"><i class="ri-login-box-line"></i> Se connecter</a>
                <a class="<?= $currentPage == 'register' ? 'active' : '' ?>" href="index.php?action=register"
                    title="Créer un compte"><i class="ri-user-add-line"></i> Créer un compte</a>
            </div>
        <?php endif; ?>
    </header>

    <main class="mt-5 pt-4">
        <?php if (isset($alert)): ?>
            <div class="alert alert-<?php echo $alert['type']; ?>" role="alert">
                <?php echo $alert['message']; ?>
            </div>
        <?php endif; ?>
    </main>