<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Modifier le profil</title>
    <link rel="stylesheet" href="public/css/style.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet">
</head>
<body>
    <button class="back-btn" onclick="window.location.href='index.php?action=profile'">&larr;</button>

    <div class="left-panel" style="background-image: url('public/images/fleur.png');"></div>

    <div class="right-panel">
        <div class="form-container">
            <div class="logo">
                <img src="public/images/logo.png" alt="Logo Crowdfund" class="logo-img">
                <span>COMMUNIFY</span>
            </div>
            <h2>Modifier votre profil</h2>
            <div class="small-text">Modifiez vos informations personnelles</div>

            <form method="post" action="index.php?action=update_profile">
                <?php if (!empty($errors)): ?>
                    <div class="alert alert-danger">
                        <ul class="mb-0">
                            <?php foreach ($errors as $error): ?>
                                <li><?php echo htmlspecialchars($error); ?></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                <?php endif; ?>
                <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($_SESSION['csrf_token'] ?? ''); ?>">
                
                <label for="nom">Nom complet <span class="star">*</span></label>
                <input type="text" id="nom" name="nom" required value="<?php echo htmlspecialchars($user->getUsername()); ?>">
                
                <label for="email">Adresse Email <span class="star">*</span></label>
                <input type="email" id="email" name="email" required value="<?php echo htmlspecialchars($user->getEmail()); ?>">
                
                <label for="current_password">Mot de passe actuel</label>
                <input type="password" id="current_password" name="current_password" placeholder="*********">
                
                <label for="new_password">Nouveau mot de passe</label>
                <input type="password" id="new_password" name="new_password" placeholder="*********">
                
                <label for="confirm_password">Confirmer le nouveau mot de passe</label>
                <input type="password" id="confirm_password" name="confirm_password" placeholder="*********">

                <button type="submit">Enregistrer les modifications</button>
            </form>

            <div class="footer">©<span id="year"></span> COMMUNIFY. Tous droits réservés.</div>
        </div>
    </div>

    <!-- Bootstrap JS and Popper.js -->
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.min.js"></script>
    <script>
        // Obtenir l'année actuelle
        const currentYear = new Date().getFullYear();
        document.getElementById('year').textContent = currentYear;

        // Validation du formulaire
        document.querySelector('form').addEventListener('submit', function(e) {
            const newPassword = document.getElementById('new_password').value;
            const confirmPassword = document.getElementById('confirm_password').value;
            const currentPassword = document.getElementById('current_password').value;

            if (newPassword || confirmPassword || currentPassword) {
                if (!currentPassword) {
                    e.preventDefault();
                    alert('Le mot de passe actuel est requis pour changer le mot de passe');
                    return;
                }
                if (newPassword !== confirmPassword) {
                    e.preventDefault();
                    alert('Les nouveaux mots de passe ne correspondent pas');
                    return;
                }
                if (newPassword.length < 8) {
                    e.preventDefault();
                    alert('Le nouveau mot de passe doit contenir au moins 8 caractères');
                    return;
                }
            }
        });
    </script>
</body>
</html> 