<!DOCTYPE html>
<html lang="fr">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Création de projet - COMMUNIFY</title>
    <link rel="shortcut icon" href="/public/images/logo.png" type="image/x-icon">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet">

    <style>
        body {
            font-family: 'Inter', sans-serif;
            background-color: #f8f9fa;
        }

        .sidebar {
            background-color: #e9e9e9;
            min-height: 100vh;
        }

        .main-content {
            background-color: #f8f9fa;
        }

        .back-button {
            color: #333;
            font-size: 24px;
            cursor: pointer;
        }

        .logo {
            color: #17a2b8;
            font-weight: 600;
            display: flex;
            align-items: center;
            margin: 20px 0;
        }

        .logo i {
            margin-right: 10px;
        }

        h1 {
            font-size: 28px;
            font-weight: 700;
            line-height: 1.2;
        }

        .sidebar-text {
            color: #555;
            font-size: 14px;
            margin-top: 15px;
        }

        .quote {
            color: #333;
            font-size: 20px;
            text-align: center;
            margin: 40px 0;
            position: relative;
            padding: 0 30px;
        }

        .quote::before {
            content: '"';
            font-size: 60px;
            color: #17a2b8;
            position: absolute;
            left: 0;
            top: -20px;
        }

        .form-section {
            margin-bottom: 30px;
        }

        .form-section h2 {
            font-size: 18px;
            font-weight: 600;
            margin-bottom: 15px;
        }

        .form-control {
            border-radius: 4px;
            padding: 12px 15px;
            border: 1px solid #ddd;
        }

        textarea.form-control {
            min-height: 150px;
        }

        .category-options {
            display: flex;
            flex-wrap: wrap;
            gap: 10px;
            margin-bottom: 20px;
        }

        .category-option {
            border: 1px solid #ddd;
            border-radius: 30px;
            padding: 8px 20px;
            cursor: pointer;
            width: fit-content;
            transition: all 0.2s;
            display: inline-block;
            font-size: 14px;
            position: relative;
        }

        .category-option input[type="radio"] {
            display: none;
        }

        .category-option:hover {
            background-color: #17a2b8;
            color: white;
            border-color: #17a2b8;
        }

        .category-option.active {
            background-color: #17a2b8;
            color: white;
            border-color: #17a2b8;
        }

        .category-option input[type="radio"]:checked+span,
        .category-option input[type="radio"]:checked {
            background-color: #17a2b8;
            color: white;
            border-color: #17a2b8;
        }

        .btn-primary {
            background-color: #17a2b8;
            border: none;
            border-radius: 30px;
            padding: 15px;
            width: 100%;
            font-weight: 600;
            margin-top: 20px;
        }

        .btn-primary:hover {
            background-color: #138496;
        }

        .btn-outline-secondary {
            border: 1px solid #ddd;
            background-color: transparent;
            color: #333;
            border-radius: 30px;
            padding: 15px;
            width: 100%;
            font-weight: 600;
            margin-top: 10px;
        }

        .btn-outline-secondary:hover {
            background-color: #f8f9fa;
            border-color: #ced4da;
        }

        @media (max-width: 767px) {

            .logo,
            .sidebar-text,
            h1 {
                text-align: center;
                justify-content: center;
            }
            .sidebar {
                padding: 20px;
                min-height: auto;
            }
        }
    </style>
</head>

<body>
    <div class="container-fluid">
        <div class="row flex-wrap">
            <!-- Sidebar -->
            <div class="col-md-4 p-4 sidebar">
                <a href="index.php?action=profile" class="back-button">
                    <i class="fas fa-chevron-left"></i>
                </a>

                <div class="logo mt-4">
                    <i class="ri-building-2-fill"></i>
                    COMMUNIFY
                </div>

                <h1>Info générale<br>sur le projet.</h1>
                <p class="sidebar-text">
                    <i class="ri-error-warning-line text-warning text-2xl"></i>
                    Modifier les informations de votre projet 
                    <p> Cela pourrait vous décrédibilisé au près des contributeurs</p>
                </p>
            </div>

            <!-- Main Content -->
            <div class="col-md-8 p-5 main-content">
                <div class="quote">
                    Modifier les informations de votre projet!!
                </div>

                <form method="post" action="index.php?action=edit_project_process" enctype="multipart/form-data">
                    <?php if (!empty($errors)): ?>
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                <?php foreach ($errors as $error): ?>
                                    <li><?php echo htmlspecialchars($error); ?></li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                    <!-- Titre du projet -->
                    <div class="form-section">
                        <h2>1. Quel est le titre de votre projet ?</h2>
                        <input type="text" name="titre" class="form-control"
                            value="<?php echo htmlspecialchars($projectDetails['titre']); ?>" placeholder="Titre">
                    </div>

                    <!-- Catégorie -->
                    <div class="form-section">
                        <h2>2. Catégorie du projet</h2>
                        <div class="category-options">
                            <?php foreach ($categories as $categorie): ?>
                                <?php
                                $selected = htmlspecialchars($projectDetails['categorie']) == htmlspecialchars($categorie['nom']);
                                ?>
                                <label class="category-option <?= $selected ? 'active' : '' ?> ">
                                    <input type="radio" name="categorie" value="<?= htmlspecialchars($categorie['nom']) ?>" <?= $selected ? 'checked' : '' ?>
                                        required>
                                    <?= htmlspecialchars($categorie['nom']) ?>
                                </label>
                            <?php endforeach; ?>
                        </div>
                    </div>

                    <!-- Montant -->
                    <div class="form-section">
                        <h2>3. Quel est le montant que vous souhaitez collecter ?</h2>
                        <input type="text" name="objectif"
                            value="<?php echo htmlspecialchars($projectDetails['objectif']); ?>" class="form-control"
                            placeholder="ex: 10000 FCFA">
                    </div>

                    <!-- Image -->
                    <div class="form-section">
                        <h2>4. Une image de votre projet</h2>
                        <input type="file" name="image" class="form-control">
                        <div class="form-text">L'image actuelle est : <img
                                src="/public/images/<?php echo htmlspecialchars($projectDetails['image']); ?>"
                                alt="Image du projet" style="width: 200px; height: auto;"></div>
                    </div>

                    <!-- Durée -->
                    <div class="form-section">
                        <h2>5. Fin de  campagne</h2>
                        <input type="date" name="end_date" class="form-control"
                            value="<?php echo htmlspecialchars($projectDetails['end_date']); ?>"
                            placeholder="ex: 2025-12-31">
                    </div>

                    <!-- Description -->
                    <div class="form-section">
                        <h2>6. Description du projet</h2>
                        <textarea name="description" class="form-control"
                            placeholder="Description de votre projet ...."><?php echo htmlspecialchars($projectDetails['description']); ?></textarea>
                    </div>

                    <!-- Hidden input for project ID -->
                    <input type="hidden" name="id" value="<?php echo htmlspecialchars($projectDetails['id']); ?>">

                    <!-- Buttons -->
                    <button type="submit" class="btn btn-primary">Modifier le projet</button>

                </form>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.querySelectorAll('.category-option input[type="radio"]').forEach(radio => {
            radio.addEventListener('change', function () {
                document.querySelectorAll('.category-option').forEach(label => {
                    label.classList.remove('active');
                });
                this.closest('.category-option').classList.add('active');
            });
        });
    </script>
</body>

</html>