<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>S'inscrire</title>
    <link rel="stylesheet" href="../public/css/style.css">
</head>
<body>
    <button class="back-btn" onclick="window.location.href='index.php?action=login'">&larr;</button>

  
    <div class="left-panel" style="background-image: url('/public/images/fleur.png');"></div>
  
    <div class="right-panel">
      <div class="form-container">
        <div class="logo">
          <img src="../public/images/logo.png" alt="Logo Crowdfund" class="logo-img">
          <span>COMMUNIFY</span>
        </div>
        <h2>Créez votre compte.</h2>
        <div class="small-text">Vous avez déjà un compte ? <a href="index.php?action=login">Connectez-vous</a></div>
  
        <form method="post" action="index.php?action=register_process" >
          <?php if (!empty($errors)): ?>
                    <div class="alert alert-danger">
                        <ul class="mb-0">
                            <?php foreach ($errors as $error): ?>
                                <li> <?php echo htmlspecialchars($error); ?></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                <?php endif; ?>
          <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($_SESSION['csrf_token'] ?? ''); ?>">
          <label for="nom">Nom complet <span class="star">*</span></label>
          <input type="text" id="nom" name="nom" required placeholder="Steven Rider">
        
          <label for="email">Adresse Email <span class="star">*</span></label>
          <input type="email" id="email" name="email" required placeholder="example@gmail.com">
        
          <label for="password">Mot de passe <span class="star">*</span></label>
          <input type="password" id="password" name="password" required placeholder="*********">
           <label for="password">Confirmer le mot de passe <span class="star">*</span></label>
          <input type="password" id="confirm_password" name="confirm_password" required placeholder="*********">
        
  
          <div class="checkbox-container">
            <input type="checkbox" id="terms">
            <label for="terms">J'accepte les termes et conditions</label>
          </div>
  
          <button type="submit">S'inscrire</button>
        </form>
  
        <div class="footer">©<span id="year"></span> COMMUNIFY. Tous droits réservés.</div>
      </div>
    </div>
  </body>
  <script>
    // Obtenir l'année actuelle
    const currentYear = new Date().getFullYear();
    document.getElementById('year').textContent = currentYear;
  </script>
</html>